<?php
/*
Plugin Name: Comment Redirect
Version: 0.1
Plugin URI: http://www.joostdevalk.nl/
Description: Redirect commenter to a thank you page after his comment has been submitted. 
Author: Joost de Valk
Author URI: http://www.joostdevalk.nl/
*/

if ( ! class_exists( 'CommentRedirect_Admin' ) ) {

	class CommentRedirect_Admin {

		function add_config_page() {
			global $wpdb;
			if ( function_exists('add_submenu_page') ) {
				add_submenu_page('plugins.php','Comment Redirect Configuration', 'Comment Redirect', 1, basename(__FILE__),array('CommentRedirect_Admin','config_page'));
			}
		}

		function config_page() {
			if ( isset($_POST['submit']) ) {
				if (!current_user_can('manage_options')) die(__('You cannot edit the Comment Redirect options.'));
				check_admin_referer('comment-redirect-updatesettings');
				
				$options['page'] = $_POST['page_id'];
				update_option('CommentRedirect', $options);
			}
			
			$options  = get_option('CommentRedirect');
			?>
			<div class="wrap">
				<h2>Comment Redirect Configuration</h2>
				<form action="" method="post" id="commentredirect-conf">
					<table class="form-table">
						<?php if (function_exists('wp_nonce_field')) { wp_nonce_field('comment-redirect-updatesettings'); } ?>
						<tr>
							<th scope="row" valign="top">Redirect to:</th>
							<td><?php wp_dropdown_pages("depth=0&selected=".$options['page']); ?></td>
						</tr>						
					</table>
					<br/>
					<span class="submit" style="border: 0;"><input type="submit" name="submit" value="Save Settings" /></span>
				</form>
			</div>
<?php		}
	}
}

function change_redirect($url, $comment) {
	global $wpdb;
	$cc = $wpdb->get_var("SELECT COUNT(comment_author_email) FROM $wpdb->comments WHERE comment_author_email = '".$comment->comment_author_email."'");
	if ($cc == 1) {
		$options  = get_option('CommentRedirect');
		return get_permalink($options['page']);	
	} else {
		return $url;
	}
}

add_filter('comment_post_redirect','change_redirect',10,2);
add_action('admin_menu', array('CommentRedirect_Admin','add_config_page'));

?>